;********************************************************
;*							*	
;*  BSTAM INTERFACE CCS 7710A CARD IN APPLE CP/M SYSTEM	*
;*							*
;********************************************************
;
;		Jan 10, 1981
;
;	By	Bill Bolton
;		Software Tools
;		P.O. Box 80
;		Newport Beach
;		NSW, 2106
;		Australia
;
;		TCY396
;
;
;VERSION 6850/4.5
;
BEGIN	ORG	103H
INITIL	JMP	INITIU			;UART/USART INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU			;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU			;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU			;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU			;WRITE DATA PORT ENTRY POINT
;
;
;
TPS	EQU	0E0A0H			;STATUS PORT
TP	EQU	TPS+1			;DATA PORT
;
;
INITIU:
	CALL	SIGNON
RESET:
	MVI	A,17H			;RESET ACIA
	STA	TPS
	MVI	A,11H			;8 BITS, 2 STOP, 16X CLK, NO PAR
	STA	TPS
	RET				;RETURN TO BSTAM
;
;
;
;
INSPRU:
	PUSH	B
	LDA	TPS			;GET STATUS
	MOV	C,A			;C <--- STATUS
	MVI	B,1			;PRESET 8251 TX READY
	ANI	1			;6850 RX DATA?
	JZ	CHKTXE			;NO
	MVI	A,02H			;YES, SET 8251 RX DATA
	ORA	B			;COMBINE WITH B
	MOV	B,A
CHKTXE:	MOV	A,C			;A <--- STATUS
	ANI	02H			;TX EMPTY?
	JZ	CHKOVR			;NO
	MVI	A,04H			;YES, SET 8251 TXE
	ORA	B			;COMBINE WITH B
	MOV	B,A
CHKOVR:	MOV	A,C			;A <--- STATUS
	ANI	20H			;RX OVERRUN
	JZ	ENDCHK			;NO
	MVI	A,10H			;YES, SET 8251 OE
	ORA	B			;COMBINE WITH B
	MOV	B,A
ENDCHK:	MOV	A,B			;A <--- 8251 LIKE STATUS
	POP	B
	RET
;
ERRSTU:
	CALL	RESET			;RESET ACIA
	RET				;RETURN TO BSTAM
;
;
INPRTU:
	LDA	TP	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
;
OUTPRU:
	STA	TP	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
;
;
MESSGE:	DB	0DH,0AH,0DH,0AH
	DB	'Version 4.5 - Software Tools',0DH,0AH
	DB	'For APPLE CP/M 2.2 with',0DH,0AH
	DB	'CCS 7710A (6850), no parity',0DH,0AH,'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5		;ANOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
